from pybricks.hubs import TechnicHub
from pybricks.pupdevices import Motor, DCMotor, Remote
from pybricks.parameters import Port, Direction, Button, Color
from pybricks.tools import wait, StopWatch

# Initialize the hub.
hub = TechnicHub()
# Connect to the remote.
remote = Remote()

# Initialize the drive motors.
drive_motor1 = Motor(Port.A)
drive_motor2 = Motor(Port.B)
print("Default drive motor1 settings:", drive_motor1.control.limits())
print("Default drive motor2 settings:", drive_motor2.control.limits())
drive_motor1.control.limits(acceleration=1000)
drive_motor2.control.limits(acceleration=1000)
print("New drive motor1 settings:", drive_motor1.control.limits())
print("New drive motor2 settings:", drive_motor2.control.limits())

# Find the steering endpoint on the left and right.
# The middle is in between.
steer_motor = Motor(Port.D, Direction.COUNTERCLOCKWISE)
print("Default steer motor settings:", steer_motor.control.limits())
# steer_motor.control.limits(acceleration=3000)
print("New steer motor settings:", steer_motor.control.limits())
left_end = steer_motor.run_until_stalled(-500)
right_end = steer_motor.run_until_stalled(500)
print("Left end:", left_end)
print("Right end:", right_end)
# Return to the center.
max_steering = int((right_end - left_end) / 2) + 3
steer_motor.reset_angle(max_steering)
steer_motor.run_target(1000, 0)

# Initialize the differential as unlocked.
lock_motor = DCMotor(Port.C)
LOCK_POWER = const(60)
LOCK_TIME = const(600)
lock_motor.dc(LOCK_POWER)
wait(LOCK_TIME)
lock_motor.stop()
locked = False
remote.light.on(Color.BLUE if locked else Color.GREEN)

def show_voltage(voltage):
        drive_motor1.stop()
        drive_motor2.stop()
        steer_motor.stop()
        lock_motor.stop()
        remote.light.on(Color.NONE)
        wait(1000)
        blink = int((voltage % 1000) / 100)
        i = 0
        while i < blink:
            remote.light.on(Color.RED)
            wait(200)
            remote.light.on(Color.NONE)
            wait(200)
            i += 1
        wait(1000)
        blink = int((voltage % 100) / 10)
        i = 0
        while i < blink:
            remote.light.on(Color.MAGENTA)
            wait(200)
            remote.light.on(Color.NONE)
            wait(200)
            i += 1
        wait(500)

cell_voltage = int(hub.battery.voltage()/6)
print("Battery pack voltage:", cell_voltage*6)
print("Battery cell voltage:", cell_voltage)
load_cell_voltage = min_cell_voltage = 2000

stopwatch = StopWatch()
stopwatch.resume()
stopwatch.reset()

# Now we can start driving!
while True:
    # Check which buttons are pressed.
    pressed = remote.buttons.pressed()

    # Choose the steer angle based on the left controls.
    steer_angle = 0
    if Button.LEFT_PLUS in pressed:
        steer_angle -= max_steering
    if Button.LEFT_MINUS in pressed:
        steer_angle += max_steering

    # Steer to the selected angle.
    steer_motor.run_target(1000, steer_angle, wait=False)

    # Choose the drive speed based on the right controls.
    if Button.RIGHT in pressed:
        drive_motor1.stop()
        drive_motor2.stop()
    elif Button.RIGHT_PLUS in pressed:
        if (drive_motor1.speed() < -10):
            drive_motor1.stop()
            drive_motor2.stop()
        else:
            drive_motor1.run(2000)
            drive_motor2.run(2000)
    elif Button.RIGHT_MINUS in pressed:
        if (drive_motor1.speed() > 10):
            drive_motor1.stop()
            drive_motor2.stop()
        else:
            drive_motor1.run(-2000)
            drive_motor2.run(-2000)
    else:
        if (abs(drive_motor1.speed()) < 10):
            drive_motor1.stop()
            drive_motor2.stop()
        else:
            drive_motor1.run(0)
            drive_motor2.run(0)

    if stopwatch.time() > 500:
        stopwatch.reset()
        cell_voltage = int(hub.battery.voltage()/6)
        if cell_voltage < min_cell_voltage:
            min_cell_voltage = cell_voltage
        # voltage increases on load probably because of measurment way
        # hack to calculate it
        load_cell_voltage = min_cell_voltage - (cell_voltage - min_cell_voltage)
        print("CellV:", cell_voltage,
              ", MinV:", min_cell_voltage,
              ", LoadV:", load_cell_voltage,
              ", Current:", hub.battery.current())
        if load_cell_voltage < 1000:
            break

    # Button for differential lock
    if Button.CENTER in pressed:
        i = 0
        while i < 10:
            wait(100)
            if Button.CENTER not in remote.buttons.pressed():
                break
            i += 1
        if i < 10:
            # Stop the drive motors
            drive_motor1.stop()
            drive_motor2.stop()

            # Run lock motor
            remote.light.on(Color.CYAN)
            lock_motor.dc(LOCK_POWER if locked else -LOCK_POWER)
            wait(LOCK_TIME)
            lock_motor.stop()

            # Update lock state.
            locked = not locked
        else:
            show_voltage(load_cell_voltage)
        remote.light.on(Color.BLUE if locked else Color.GREEN)

    # Wait.
    wait(10)

drive_motor1.stop()
drive_motor2.stop()
steer_motor.stop()
lock_motor.stop()

while True:
    show_voltage(load_cell_voltage)
    wait(2000)
